# 機能設計書 155-API Priority and Fairness

## 概要

本ドキュメントは、API Serverへのリクエストの優先度制御とフェアキューイングを行う「API Priority and Fairness」機能の設計について記述する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetes API Serverは多数のクライアント（コントローラー、スケジューラー、ユーザー等）からのリクエストを処理する。特定のクライアントによる大量リクエストが他のクライアントのレスポンスを阻害しないよう、リクエストの優先度に基づくフェアキューイング機構を提供する。これにより、高負荷時でもクリティカルなシステムコンポーネントのAPIアクセスが保証される。

**機能の利用シーン**：API Serverの起動時にブートストラップ設定が自動適用される。管理者がFlowSchemaとPriorityLevelConfigurationを定義してカスタムの優先度制御を構成する際に利用される。

**主要な処理内容**：
1. FlowSchemaリソースのCRUD管理とストレージ（etcd永続化）
2. PriorityLevelConfigurationリソースのCRUD管理とストレージ
3. ブートストラップ設定の自動適用（必須設定と推奨設定）
4. ブートストラップ設定の定期的な差分適用（1分間隔）
5. 不要なブートストラップオブジェクトの自動削除
6. FlowSchemaおよびPriorityLevelConfigurationのバリデーションとステータス管理

**関連システム・外部連携**：etcd（永続化ストレージ）、API Server（リクエスト処理パイプライン）、Informerキャッシュ。

**権限による制御**：FlowSchema/PriorityLevelConfigurationはクラスタースコープのリソースであり、作成・変更にはcluster-admin相当の権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | バックエンドAPIのため関連画面なし |

## 機能種別

CRUD操作 / 設定管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| FlowSchema.spec | FlowSchemaSpec | Yes | フロースキーマの仕様 | validation.ValidateFlowSchema |
| PriorityLevelConfiguration.spec | PriorityLevelConfigurationSpec | Yes | 優先度レベル設定の仕様 | validation.ValidatePriorityLevelConfiguration |

### 入力データソース

- API Serverへの直接的なREST APIリクエスト
- ブートストラップポリシー（flowcontrolbootstrap パッケージのハードコード値）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| FlowSchema | Object | フロースキーマリソース（spec + status） |
| PriorityLevelConfiguration | Object | 優先度レベル設定リソース（spec + status） |

### 出力先

etcd（永続化）、API Serverのレスポンス

## 処理フロー

### 処理シーケンス

```
1. API Server起動
   └─ PostStartHook "priority-and-fairness-config-producer" が登録される
2. Informerキャッシュの同期待機（最大5分）
   └─ FlowSchemaとPriorityLevelConfigurationのInformerが同期完了するまで待機
3. ブートストラップ設定の適用（初回）
   └─ 推奨設定 → 必須設定 → 不要オブジェクト削除 の順序で実行
4. 定期的な差分適用（1分間隔）
   └─ バックグラウンドgoroutineで継続的に設定を確認・更新
```

### フローチャート

```mermaid
flowchart TD
    A[API Server起動] --> B[PostStartHook登録]
    B --> C[Informerキャッシュ同期待機]
    C --> D{同期完了?}
    D -->|No 5分超過| E[エラー返却]
    D -->|Yes| F[推奨設定の適用]
    F --> G[必須設定の適用]
    G --> H[不要オブジェクト削除]
    H --> I[定期差分適用goroutine開始]
    I --> J[1分間隔で設定確認・更新]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-155-1 | 必須設定不変 | 必須（Mandatory）設定は常に上書きされ、ユーザーによる変更は復元される | 定期差分適用時 |
| BR-155-2 | 推奨設定尊重 | 推奨（Suggested）設定はユーザーが変更した場合は変更を尊重する | 定期差分適用時 |
| BR-155-3 | 初回タイムアウト | 初回ブートストラップ設定適用はInformer同期完了後5分以内に完了する必要がある | API Server起動時 |
| BR-155-4 | リトライ | 設定適用が失敗した場合、1秒間隔でリトライする | 初回適用時 |
| BR-155-5 | ステータス分離 | Spec更新時にStatusは変更されない（GetResetFieldsで保護） | FlowSchema更新時 |
| BR-155-6 | Generation管理 | Spec変更時にGenerationがインクリメントされる | FlowSchema更新時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ブートストラップ設定作成 | flowschemas | INSERT | 推奨・必須フロースキーマの作成 |
| ブートストラップ設定作成 | prioritylevelconfigurations | INSERT | 推奨・必須優先度レベル設定の作成 |
| ブートストラップ差分適用 | flowschemas | UPDATE | 差分のある設定の更新 |
| 不要設定削除 | flowschemas, prioritylevelconfigurations | DELETE | 廃止されたブートストラップオブジェクトの削除 |
| ステータス更新 | flowschemas, prioritylevelconfigurations | UPDATE | ステータスサブリソースの更新 |

### テーブル別操作詳細

#### flowschemas

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | spec, metadata | ブートストラップポリシーの値 | 推奨設定と必須設定 |
| UPDATE | spec | 差分のあるフィールド | Generation自動インクリメント |
| UPDATE | status | condition情報 | ステータスサブリソースのみ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | キャッシュ同期タイムアウト | Informer同期が5分以内に完了しない | etcd接続を確認 |
| - | ブートストラップ適用失敗 | etcd書き込みエラー | 1秒間隔で自動リトライ |
| - | バリデーションエラー | 不正なFlowSchema/PriorityLevelConfiguration | リクエストを修正 |

### リトライ仕様

初回ブートストラップ適用は`wait.PollImmediateUntilWithContext`で1秒間隔リトライ。定期差分適用は1分間隔で自動リトライ（エラーログ出力後に継続）。

## トランザクション仕様

各リソースの操作はetcdのアトミック操作で実行される。複数リソース間のトランザクションはないが、推奨→必須→削除の順序で実行される。

## パフォーマンス要件

PostStartHookは5分以内に完了する必要がある。定期差分適用は1分間隔でバックグラウンド実行される。

## セキュリティ考慮事項

- FlowSchema/PriorityLevelConfigurationはクラスタースコープリソースであり、変更にはcluster-admin権限が必要
- 必須設定は自動復元されるため、不正な変更は自動的に修正される
- APIリクエストの分離により、特定クライアントによるAPI Serverの独占を防止

## 備考

- flowcontrol.apiserver.k8s.io APIグループに属する
- v1（GA）バージョンが利用可能
- PostStartHook名: "priority-and-fairness-config-producer"

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | strategy.go (FlowSchema) | `pkg/registry/flowcontrol/flowschema/strategy.go` | FlowSchemaのバリデーション・準備ロジック |
| 1-2 | strategy.go (PLC) | `pkg/registry/flowcontrol/prioritylevelconfiguration/strategy.go` | PriorityLevelConfigurationの戦略 |

**読解のコツ**: FlowSchema strategyの**48-65行目**でGetResetFieldsが定義されており、各APIバージョンでstatusフィールドがリセット対象になっている。**68-72行目**のPrepareForCreateでStatusがクリアされGeneration=1に設定される。**75-84行目**のPrepareForUpdateでSpec変更時にGenerationがインクリメントされる。

#### Step 2: ストレージ層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | storage.go (FlowSchema) | `pkg/registry/flowcontrol/flowschema/storage/storage.go` | FlowSchemaのREST API実装 |
| 2-2 | storage.go (PLC) | `pkg/registry/flowcontrol/prioritylevelconfiguration/storage/storage.go` | PLCのREST API実装 |

#### Step 3: RESTストレージプロバイダーとPostStartHookを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | storage_flowcontrol.go | `pkg/registry/flowcontrol/rest/storage_flowcontrol.go` | RESTストレージプロバイダーとブートストラップ設定 |

**主要処理フロー**:
- **53行目**: PostStartHookName定数 "priority-and-fairness-config-producer"
- **56-66行目**: NewRESTStorageでFlowSchemaとPLCのストレージマップを構築
- **100-110行目**: PostStartHookでbootstrapConfigurationEnsurerを初期化
- **118-169行目**: ensureAPFBootstrapConfigurationがメインのブートストラップ処理。5分タイムアウト付きキャッシュ同期→1秒間隔リトライ→成功後に1分間隔のgoroutine起動
- **171-189行目**: ensure関数で推奨設定→必須設定→不要オブジェクト削除の順序で実行

#### Step 4: Ensurerロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | strategy.go (ensurer) | `pkg/registry/flowcontrol/ensurer/strategy.go` | 推奨/必須の適用戦略 |
| 4-2 | flowschema.go (ensurer) | `pkg/registry/flowcontrol/ensurer/flowschema.go` | FlowSchema用のCRUD操作 |
| 4-3 | prioritylevelconfiguration.go (ensurer) | `pkg/registry/flowcontrol/ensurer/prioritylevelconfiguration.go` | PLC用のCRUD操作 |

### プログラム呼び出し階層図

```
RESTStorageProvider.PostStartHook()
    |
    +-- bootstrapConfigurationEnsurer.ensureAPFBootstrapConfiguration()
           |
           +-- cache.WaitForCacheSync() (Informer同期待機)
           |
           +-- ensure() (初回適用)
           |      +-- ensureSuggestedConfiguration()
           |      |      +-- ensurer.EnsureConfigurations() [PLC]
           |      |      +-- ensurer.EnsureConfigurations() [FlowSchema]
           |      +-- ensureMandatoryConfiguration()
           |      |      +-- ensurer.EnsureConfigurations() [PLC]
           |      |      +-- ensurer.EnsureConfigurations() [FlowSchema]
           |      +-- removeDanglingBootstrapConfiguration()
           |             +-- ensurer.RemoveUnwantedObjects() [FlowSchema]
           |             +-- ensurer.RemoveUnwantedObjects() [PLC]
           |
           +-- goroutine: ensure() (1分間隔で継続)
```

### データフロー図

```
[入力]                          [処理]                            [出力]

ブートストラップポリシー ──> bootstrapConfigurationEnsurer ──> etcd (FlowSchema)
(ハードコード値)              (推奨/必須設定の適用)               etcd (PLC)

API リクエスト ──────────> FlowSchema Strategy ──────────> etcd (FlowSchema)
(ユーザー定義)               (バリデーション/準備)               API レスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| storage_flowcontrol.go | `pkg/registry/flowcontrol/rest/storage_flowcontrol.go` | ソース | RESTストレージプロバイダーとPostStartHook |
| strategy.go | `pkg/registry/flowcontrol/flowschema/strategy.go` | ソース | FlowSchemaのバリデーション・準備戦略 |
| storage.go | `pkg/registry/flowcontrol/flowschema/storage/storage.go` | ソース | FlowSchemaのストレージ実装 |
| strategy.go | `pkg/registry/flowcontrol/prioritylevelconfiguration/strategy.go` | ソース | PLCのバリデーション・準備戦略 |
| storage.go | `pkg/registry/flowcontrol/prioritylevelconfiguration/storage/storage.go` | ソース | PLCのストレージ実装 |
| strategy.go | `pkg/registry/flowcontrol/ensurer/strategy.go` | ソース | 推奨/必須の適用戦略 |
| flowschema.go | `pkg/registry/flowcontrol/ensurer/flowschema.go` | ソース | FlowSchemaのensurer操作 |
| prioritylevelconfiguration.go | `pkg/registry/flowcontrol/ensurer/prioritylevelconfiguration.go` | ソース | PLCのensurer操作 |
